/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.esl.energy;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1935;
import org.antarcticgardens.esl.ESL;
import org.antarcticgardens.esl.energy.EnergyStorage;
import org.antarcticgardens.esl.util.ItemHolder;

public abstract class ItemEnergyStorageManager {
    private final Map<class_1935, Function<ItemHolder, EnergyStorage>> providers = new HashMap<class_1935, Function<ItemHolder, EnergyStorage>>();

    public void register(Function<ItemHolder, EnergyStorage> provider, class_1935 item) {
        if (this.providers.containsKey(item)) {
            ESL.LOGGER.trace("Duplicate energy storage registration for " + item);
            return;
        }
        this.providers.put(item, provider);
        this.platformRegister(provider, item);
    }

    public boolean isItemRegisteredInESL(class_1935 item) {
        return this.providers.containsKey(item);
    }

    public EnergyStorage find(ItemHolder holder) {
        EnergyStorage storage;
        Function<ItemHolder, EnergyStorage> provider = this.providers.get(holder.getItem());
        if (provider != null && (storage = provider.apply(holder)) != null) {
            return storage;
        }
        return this.platformFind(holder);
    }

    protected abstract void platformRegister(Function<ItemHolder, EnergyStorage> var1, class_1935 var2);

    protected abstract EnergyStorage platformFind(ItemHolder var1);
}

